IMPLEMENTATION MODULE Pantalla;

FROM InOut IMPORT Write, WriteLn, WriteString;

PROCEDURE CrearVacia(VAR pantalla: TipoPantalla;
		         numLineas: RangoLineas;
			 numColumnas: RangoColumnas);
VAR
   i: RangoLineas;
   j: RangoColumnas;
BEGIN
   pantalla.numLineas := numLineas;
   pantalla.numColumnas := numColumnas;
   pantalla.linea := 1;
   pantalla.columna := 1;
   FOR i:=1 TO numLineas DO
      FOR j:=1 TO numColumnas DO
         pantalla.pantalla[i, j] := ' ';
      END; (* FOR j *)
   END; (* FOR i *)
END CrearVacia;

PROCEDURE MensajeError(codigo: INTEGER);
BEGIN
   WriteString("<< ERROR: ");
   CASE codigo OF
      1: WriteString("La ristra no cabe en la pantalla"); |
      2: WriteString("El numero no cabe en la pantalla"); |
      3: WriteString("La pantalla origen no cabe en la pantalla destino"); |
      4: WriteString("El ao debe valer entre 1601 y 3000"); |
      5: WriteString("El mes debe valer entre 0 y 12");
   END; (* CASE *)
   WriteString(" >>");
   WriteLn;
END MensajeError;

PROCEDURE CambiarCoordenadas(VAR pantalla: TipoPantalla;
  				 linea:RangoLineas;
  				 columna: RangoColumnas);
BEGIN
   pantalla.linea := linea;
   pantalla.columna := columna;
END CambiarCoordenadas;

PROCEDURE EscribirRistra(VAR pantalla: TipoPantalla; ristra: ARRAY OF CHAR);
VAR
   i: CARDINAL;
BEGIN
   IF (HIGH(ristra) > (pantalla.numColumnas - pantalla.columna)) OR
      (pantalla.linea > pantalla.numLineas) THEN
      MensajeError(1);
      RETURN;
   END; (* IF *)
   FOR i:=0 TO HIGH(ristra) DO
      pantalla.pantalla[pantalla.linea, pantalla.columna] := ristra[i];
      IF pantalla.columna = pantalla.numColumnas THEN
         INC(pantalla.linea);
         pantalla.columna := 1;
      ELSE
         INC(pantalla.columna);
      END; (* IF *)
   END; (* FOR *)
END EscribirRistra;

PROCEDURE NumeroDeDigitos(numero: CARDINAL): CARDINAL;
VAR
   numDigitos: CARDINAL;
BEGIN
   numDigitos := 1;
   WHILE numero >= 10 DO
      INC(numDigitos);
      numero := numero DIV 10;
   END; (* WHILE *)
   RETURN numDigitos;
END NumeroDeDigitos;

PROCEDURE EscribirNumero(VAR pantalla: TipoPantalla; numero: CARDINAL; numEspacios: CARDINAL);
VAR
   numDigitos, i: CARDINAL;
BEGIN
   IF (numEspacios > (pantalla.numColumnas - pantalla.columna + 1)) OR
      (pantalla.linea > pantalla.numLineas) THEN
      MensajeError(2);
      RETURN;
   END; (* IF *)
   numDigitos := NumeroDeDigitos(numero);
   FOR i:=1 TO numEspacios-numDigitos DO
      pantalla.pantalla[pantalla.linea, pantalla.columna] := ' ';
      INC(pantalla.columna);
   END; (* FOR *)
   FOR i:=1 TO numDigitos-1 DO
      pantalla.pantalla[pantalla.linea, pantalla.columna + numDigitos - i] :=
                                                 CHR(numero MOD 10 + ORD("0"));
      numero := numero DIV 10;
   END; (* FOR *)
   pantalla.pantalla[pantalla.linea, pantalla.columna] := CHR(numero + ORD("0"));
   IF pantalla.columna + numDigitos > pantalla.numColumnas THEN
      INC(pantalla.linea);
      pantalla.columna := 1;
   ELSE
      pantalla.columna := pantalla.columna + numDigitos;
   END; (* IF *)
END EscribirNumero;

PROCEDURE EscribirPantalla(VAR destino: TipoPantalla;
			   VAR origen: TipoPantalla);
VAR
   i, j: CARDINAL;
BEGIN
   IF (origen.numLineas > destino.numLineas - destino.linea + 1) OR
      (origen.numColumnas > destino.numColumnas - destino.columna + 1) THEN
      MensajeError(3);
      RETURN;
   END; (* IF *)
   FOR i:=1 TO origen.numLineas DO
      FOR j:=1 TO origen.numColumnas DO
	destino.pantalla[destino.linea+i-1, destino.columna+j-1] := origen.pantalla[i, j];
      END; (* FOR j *)
   END; (* FOR i *)
   IF destino.columna + origen.numColumnas > destino.numColumnas THEN
      destino.linea := destino.linea + origen.numLineas;
      destino.columna := 1;
   ELSE
      destino.columna := destino.columna + origen.numColumnas;
   END; (* IF *)
END EscribirPantalla;

PROCEDURE Imprimir(VAR pantalla: TipoPantalla);
				
VAR
   i: RangoLineas;
   j: RangoColumnas;
BEGIN
   FOR i:=1 TO pantalla.numLineas DO
      FOR j:=1 TO pantalla.numColumnas DO
         Write(pantalla.pantalla[i, j]);
      END; (* FOR j *)
      WriteLn;
   END; (* FOR i *)
END Imprimir;

END Pantalla.