IMPLEMENTATION MODULE CMensual;

IMPORT Pantalla;

TYPE
    TipoDiaSemana = (Lunes, Martes, Miercoles, Jueves, Viernes, Sabado, Domingo);
    RangoDias = [1..31];

PROCEDURE EscribirCabecera(VAR calendario: TipoCalendario; mes: RangoMeses; anno: RangoAnnos);
BEGIN
   CASE mes OF
     1: Pantalla.EscribirRistra(calendario, "ENERO"); |
     2: Pantalla.EscribirRistra(calendario, "FEBRERO"); |
     3: Pantalla.EscribirRistra(calendario, "MARZO"); |
     4: Pantalla.EscribirRistra(calendario, "ABRIL"); |
     5: Pantalla.EscribirRistra(calendario, "MAYO"); |
     6: Pantalla.EscribirRistra(calendario, "JUNIO"); |
     7: Pantalla.EscribirRistra(calendario, "JULIO"); |
     8: Pantalla.EscribirRistra(calendario, "AGOSTO"); |
     9: Pantalla.EscribirRistra(calendario, "SEPTIEMBRE"); |
    10: Pantalla.EscribirRistra(calendario, "OCTUBRE"); |
    11: Pantalla.EscribirRistra(calendario, "NOVIEMBRE");
  ELSE
     Pantalla.EscribirRistra(calendario, "DICIEMBRE");
  END; (* CASE *)     	
  Pantalla.CambiarCoordenadas(calendario, 1, 19);
  Pantalla.EscribirNumero(calendario, anno, 4);
  Pantalla.EscribirRistra(calendario, "======================");
  Pantalla.EscribirRistra(calendario, "LU MA MI JU VI | SA DO");
  Pantalla.EscribirRistra(calendario, "======================");
END EscribirCabecera;

PROCEDURE EsBisiesto(Anno: RangoAnnos): BOOLEAN;
BEGIN
    RETURN (((Anno MOD 4) = 0) AND
           NOT ((Anno MOD 100) = 0)) OR
           ((Anno MOD 400) = 0);
END EsBisiesto;

PROCEDURE NumeroDeDiasDeMes(mes: RangoMeses; anno: RangoAnnos): RangoDias;
VAR
   numTotalDias: RangoDias;
BEGIN
   CASE mes OF
     1: numTotalDias := 31 |
     2: numTotalDias := 28 |
     3: numTotalDias := 31 |
     4: numTotalDias := 30 |
     5: numTotalDias := 31 |
     6: numTotalDias := 30 |
     7: numTotalDias := 31 |
     8: numTotalDias := 31 |
     9: numTotalDias := 30 |
    10: numTotalDias := 31 |
    11: numTotalDias := 30
  ELSE
     numTotalDias := 31;
  END; (* CASE *)
  IF (mes = 2) AND EsBisiesto(anno) THEN
    numTotalDias := 29;
  END; (* IF *)
  RETURN numTotalDias;
END NumeroDeDiasDeMes;

PROCEDURE DiaInicial(mes: RangoMeses; anno: RangoAnnos): TipoDiaSemana;
  CONST
    DiaInicial1601 = Lunes;
    NumDiasSemana = 7;
  VAR
    increInicial, increDias, increAnno, increBisiesto: INTEGER;
BEGIN
    CASE mes OF
       1: increDias := 0 |
       2: increDias := 3 |
       3: increDias := 3 |
       4: increDias := 6 |
       5: increDias := 1 |
       6: increDias := 4 |
       7: increDias := 6 |
       8: increDias := 2 |
       9: increDias := 5 |
      10: increDias := 0 |
      11: increDias := 3
    ELSE
       increDias := 5;
    END; (* CASE *)
    increInicial := ORD(DiaInicial1601);
    increAnno := anno - AnnoInicial;
    increBisiesto := (increAnno DIV 4) - (increAnno DIV 100) + (increAnno DIV 400);
    increDias := increInicial + increDias + increAnno + increBisiesto;
    IF EsBisiesto(anno) AND (mes > 2) THEN
      increDias := increDias + 1;
    END; (* IF *)
    increDias := increDias MOD NumDiasSemana;
    RETURN VAL(TipoDiaSemana, increDias);
END DiaInicial;

PROCEDURE Crear (VAR calendario: TipoCalendario; mes: RangoMeses; anno: RangoAnnos);
VAR
   numTotalDias, contadorDias, auxDia: RangoDias;
   diaInicial, auxSem: TipoDiaSemana;

BEGIN
   Pantalla.CrearVacia(calendario, 10, 22);
   EscribirCabecera(calendario, mes, anno);
   numTotalDias := NumeroDeDiasDeMes(mes, anno);
   contadorDias := 1;
   diaInicial := DiaInicial(mes, anno);
   IF diaInicial > Lunes THEN
      DEC(diaInicial);
      FOR auxSem := Lunes TO diaInicial DO
	 IF auxSem = Viernes THEN
	    Pantalla.EscribirRistra(calendario, " . | ");
	 ELSE
	    Pantalla.EscribirRistra(calendario, " . ");
	 END; (* IF *)	
      END; (* FOR *)
      INC(diaInicial);
      FOR auxSem := diaInicial TO Domingo DO
	 Pantalla.EscribirNumero(calendario, contadorDias, 2);
	 INC(contadorDias);
	 IF auxSem = Viernes THEN
   	    Pantalla.EscribirRistra(calendario, " | ");
	 ELSIF auxSem <> Domingo THEN
 	    Pantalla.EscribirRistra(calendario, " ");
	 END; (* IF *)
      END; (* FOR *)
      diaInicial := Lunes;
   END; (* IF *)
   FOR auxDia := contadorDias TO numTotalDias DO
      Pantalla.EscribirNumero(calendario, auxDia, 2);
      IF diaInicial = Viernes THEN
         Pantalla.EscribirRistra(calendario, " | ");
	 INC(diaInicial);
      ELSIF diaInicial = Domingo THEN
         diaInicial := Lunes;
      ELSE
         Pantalla.EscribirRistra(calendario, " ");
	 INC(diaInicial);
      END; (* IF *)
   END; (* FOR *)
   IF diaInicial > Lunes THEN
      FOR auxSem := diaInicial TO Domingo DO
	 IF auxSem = Viernes THEN
	    Pantalla.EscribirRistra(calendario, " . | ");
	 ELSIF auxSem = Domingo THEN
	    Pantalla.EscribirRistra(calendario, " .");
         ELSE
	    Pantalla.EscribirRistra(calendario, " . ");
	 END; (* IF *)	
      END; (* FOR *)
   END; (* IF *)


END Crear;    	

PROCEDURE Imprimir (VAR calendario: TipoCalendario);
BEGIN
   Pantalla.Imprimir(calendario);
END Imprimir;

END CMensual.